//+------------------------------------------------------------------+
//|                                                         RSIP.mq4 |
//|                                       Copyright  2006, Akuma99. |
//|                                      http://akuma99.blogspot.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Akuma99."
#property link      "http://akuma99.blogspot.com"

#property indicator_chart_window
#property indicator_buffers 8
#property indicator_color1 Red
#property indicator_color2 Red
#property indicator_color3 Red
#property indicator_color4 Red
#property indicator_color5 Blue
#property indicator_color6 Blue
#property indicator_color7 Blue
#property indicator_color8 Blue

//---- input parameters
extern int          mode=0;
extern double       period=32;
extern double       overboughtStart=55;
extern double       overboughtEnd=75;
extern double       oversoldStart=45;
extern double       oversoldEnd=25;

//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double ExtMapBuffer5[];
double ExtMapBuffer6[];
double ExtMapBuffer7[];
double ExtMapBuffer8[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
  
   IndicatorBuffers(8);
   
//---- indicators
   
   SetIndexStyle(0,DRAW_LINE);//,2,1,indicator_color2);
   SetIndexBuffer(0,ExtMapBuffer1);
   
   SetIndexStyle(1,DRAW_LINE);//,2,1,indicator_color3);
   SetIndexBuffer(1,ExtMapBuffer2);
   
   SetIndexStyle(2,DRAW_HISTOGRAM,STYLE_DOT);//,2,1,indicator_color4);
   SetIndexBuffer(2,ExtMapBuffer3);
   
   SetIndexStyle(3,DRAW_HISTOGRAM,STYLE_DOT);//,2,1,indicator_color5);
   SetIndexBuffer(3,ExtMapBuffer4);
   
   SetIndexStyle(4,DRAW_LINE);//,2,1,indicator_color5);
   SetIndexBuffer(4,ExtMapBuffer5);
   
   SetIndexStyle(5,DRAW_LINE);//,2,1,indicator_color5);
   SetIndexBuffer(5,ExtMapBuffer6);
   
   SetIndexStyle(6,DRAW_HISTOGRAM,STYLE_DOT);//,2,1,indicator_color5);
   SetIndexBuffer(6,ExtMapBuffer7);
   
   SetIndexStyle(7,DRAW_HISTOGRAM,STYLE_DOT);//,2,1,indicator_color5);
   SetIndexBuffer(7,ExtMapBuffer8);
   
   Comment("Wilson channels: available modes: 0=RSI, 1=Stochastic, 2=MFI, 3=deMarker, 4=Williams");
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
   int    limit=Bars-counted_bars;
   double n,os1,ob1,os2,ob2;
//----
   for(int i=limit; i>=0; i--) {
      
      n = breakDownToPrice(i,50);
      os1 = breakDownToPrice(i,overboughtEnd);
      os2 = breakDownToPrice(i,overboughtStart);
      ob1 = breakDownToPrice(i,oversoldStart);
      ob2 = breakDownToPrice(i,oversoldEnd);
      
      ExtMapBuffer1[i]=ob2;
      ExtMapBuffer2[i]=ob1;
      ExtMapBuffer3[i]=ob2;
      ExtMapBuffer4[i]=ob1;
      ExtMapBuffer5[i]=os2;
      ExtMapBuffer6[i]=os1;
      ExtMapBuffer7[i]=os2;
      ExtMapBuffer8[i]=os1;
   
   }
   
   
//----
   return(0);
  }
//+------------------------------------------------------------------+

double breakDownToPrice(int cnt, int v) {
   
   double c;
   
   switch (mode) {
   
      case 0: //rsi
         c = iRSI(NULL,0,period,PRICE_CLOSE,cnt+1)-v;
         break;
      case 1: //stochastic
         c = iStochastic(NULL,0,period,3,3,MODE_SMA,0,MODE_MAIN,cnt+1)-v;
         break;
      case 2: //money flow index
         c = iMFI(NULL,0,period,cnt+1)-v;
         break;
      case 3: //demarker
         c = (iDeMarker(NULL,0,period,cnt+1)*100)-v;
         break;
      case 4:
         c = iWPR(NULL,0,period,cnt+1)+v;
         break;
    }
    
   c = c/100;
   c = Close[cnt+1]*c;
   c = Close[cnt+1]-c;
   
   return (c);

}